<?php
session_start();
include 'assets/includes/db.php';
include 'assets/includes/config.php';

// Error reporting
if ($_ERRORS) {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
}

// Session check
if (!isset($_SESSION['loggedin']) && !$_SESSION['loggedin']) {
    header('location: logout.php');
}

// Theme Settings Handler
if (isset($_POST['submit_theme'])) {
    $sql = 'UPDATE xc_xciptv_app SET ';
    if (!isset($_POST['theme-api']) && ($_POST['theme'] != 'new_layout')) {
        $sql .= 'theme = \'' . substr($_POST['theme'], -1) . '\';';
    } else {
        $sql .= 'theme = \'' . $_POST['theme'] . '\';';
    }
    $sqlite3->exec($sql);
    header('Location: ottrunxciptv_customization.php');
}

// ExoPlayer Settings Handler
if (isset($_POST['submit_exo'])) {
    $sql = 'UPDATE xc_ort_settings SET 
        exo_hw = \'' . $_POST['exo_hw'] . '\',
        last_volume_exo = \'' . $_POST['last_volume_exo'] . '\',
        player_exo_buffer = \'' . $_POST['player_exo_buffer'] . '\',
        video_resize_exo = \'' . $_POST['video_resize_exo'] . '\',
        video_subtitles_exo = \'' . $_POST['video_subtitles_exo'] . '\';';
    $sqlite3->exec($sql);
    header('Location: ottrunxciptv_customization.php');
}

// VLC Player Settings Handler
if (isset($_POST['submit_vlc'])) {
    $sql = 'UPDATE xc_ort_settings SET 
        vlc_hw = \'' . $_POST['vlc_hw'] . '\',
        last_volume_vlc = \'' . $_POST['last_volume_vlc'] . '\',
        player_vlc_buffer = \'' . $_POST['player_vlc_buffer'] . '\',
        video_resize_vlc = \'' . $_POST['video_resize_vlc'] . '\',
        video_subtitles_vlc = \'' . $_POST['video_subtitles_vlc'] . '\';';
    $sqlite3->exec($sql);
    header('Location: ottrunxciptv_customization.php');
}

// Intro Video Upload Handler
if (isset($_POST['submit_intro'])) {
    move_uploaded_file($_FILES['intro']['tmp_name'], './api/intro.mp4');
    header('Location: ottrunxciptv_customization.php');
}

// TV Sports Guide Settings Handler
if (isset($_POST['submit_tvsg'])) {
    $sql = 'UPDATE tvsg_settings SET 
        widget_id = \'' . $_POST['widget_id'] . '\',
        border_color = \'' . $_POST['border_color'] . '\',
        background_color = \'' . $_POST['background_color'] . '\',
        text_color = \'' . $_POST['text_color'] . '\';';
    $sqlite3->exec($sql);
    header('Location: ottrunxciptv_customization.php');
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <?php include './assets/includes/title-meta.php'; ?>
    <?php include './assets/includes/head-css.php'; ?>
</head>

<body data-sidebar="dark">
    <!-- Loader -->
    <div id="preloader">
        <div id="status">
            <div class="spinner">
                <i class="ri-loader-line spin-icon"></i>
            </div>
        </div>
    </div>

    <div id="layout-wrapper">
        <?php include 'assets/includes/topbar.php'; ?>
        <?php include 'assets/includes/sidebar.php'; ?>

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <!-- Breadcrumb -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-flex align-items-center justify-content-between">
                                <h4 class="mb-0"></h4>
                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">OTTRun XCIPTV</a></li>
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Configuration</a></li>
                                        <li class="breadcrumb-item active">Customization</li>
                                    </ol>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Theme Settings Section -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="card-title">Themes</h4>
                                    <p class="card-title-desc">
                                        The selected layout will affect all connected applications.<br>
                                        Not all Themes work on all versions.<br>
                                        Not all Apps support Theme selection.
                                    </p>

                                    <form method="POST">
                                        <div class="form-group col-4 mx-auto">
                                            <div class="square-switch">
                                                <select class="custom-select" id="theme" name="theme">
                                                    <option value="theme_d" <?php echo ($xciptv_app_data['theme'] == 'theme_d' || $xciptv_app_data['theme'] == 'd') ? 'selected' : ''; ?>>Default</option>
                                                    <option value="theme_1" <?php echo ($xciptv_app_data['theme'] == 'theme_1' || $xciptv_app_data['theme'] == '1') ? 'selected' : ''; ?>>Theme 1</option>
                                                    <option value="theme_2" <?php echo ($xciptv_app_data['theme'] == 'theme_2' || $xciptv_app_data['theme'] == '2') ? 'selected' : ''; ?>>Theme 2</option>
                                                    <option value="theme_3" <?php echo ($xciptv_app_data['theme'] == 'theme_3' || $xciptv_app_data['theme'] == '3') ? 'selected' : ''; ?>>Theme 3</option>
                                                    <option value="theme_4" <?php echo ($xciptv_app_data['theme'] == 'theme_4' || $xciptv_app_data['theme'] == '4') ? 'selected' : ''; ?>>New Layout</option>
                                                </select>
                                            </div>

                                            <div class="form-group">
                                                <label for="theme-api">Old API? <small>e.g. 'theme_d' over 'd'</small></label>
                                                <div class="square-switch float-right">
                                                    <input type="checkbox" id="theme-api" name="theme-api" switch="bool" 
                                                           <?php echo strlen($xciptv_app_data['theme']) == 7 ? 'checked' : ''; ?>>
                                                    <label for="theme-api" data-on-label="Yes" data-off-label="No"></label>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <button class="btn btn-primary" name="submit_theme" type="submit">Save</button>
                                        </div>
                                    </form>
                                </div>

                                <div id="accordion" class="custom-accordion">
                                    <div class="card mb-1 shadow-none">
                                        <a href="#collapseOne" class="text-dark" data-toggle="collapse" aria-expanded="false" aria-controls="collapseOne">
                                            <div class="card-header" id="headingOne">
                                                <h6 class="m-0">
                                                    Theme Images
                                                    <i class="mdi mdi-minus float-right accor-plus-icon"></i>
                                                </h6>
                                            </div>
                                        </a>

                                        <div id="collapseOne" class="collapse" aria-labelledby="headingOne" data-parent="#accordion">
                                            <div class="card-body">
                                                <div class="row">
                                                    <div class="col-3">
                                                        Default <br>
                                                        <a href="assets/images/layouts/otr-theme_d.png">
                                                            <img width="265" height="150" src="assets/images/layouts/otr-theme_d.png">
                                                        </a>
                                                    </div>

                                                    <div class="col-3">
                                                        Theme 1 <br>
                                                        <a href="assets/images/layouts/otr-theme_1.png">
                                                            <img width="265" height="150" src="assets/images/layouts/otr-theme_1.png">
                                                        </a>
                                                    </div>

                                                    <div class="col-3">
                                                        Theme 2 <br>
                                                        <a href="assets/images/layouts/otr-theme_2.png">
                                                            <img width="265" height="150" src="assets/images/layouts/otr-theme_2.png">
                                                        </a>
                                                    </div>

                                                    <div class="col-3">
                                                        Theme 3 <br>
                                                        <a href="assets/images/layouts/otr-theme_3.png">
                                                            <img width="265" height="150" src="assets/images/layouts/otr-theme_3.png">
                                                        </a>
                                                    </div>
                                                </div>

                                                <div class="row">
                                                    <div class="col-3">
                                                        New Layout <br>
                                                        <a href="assets/images/layouts/otr-theme_4.png">
                                                            <img width="265" height="150" src="assets/images/layouts/otr-theme_4.png">
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Player Settings Section -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="card-title">Player Settings</h4>
                                    <p class="card-title-desc">
                                        The selected settings will affect all connected applications.<br>
                                        Not all Apps support Player settings (from panel).
                                    </p>

                                    <div class="col-6 float-left">
                                        ExoPlayer Settings
                                        <div class="card-body">
                                            <form method="POST">
                                                <div class="form-group">
                                                    <label class="control-label" for="player_exo_buffer">Set Buffer Size:</label>
                                                    <select class="form-control" id="select" name="player_exo_buffer">
                                                        <option value="10000" <?php echo $xciptv_ort_settings['player_exo_buffer'] == '10000' ? 'selected' : ''; ?>>10 Seconds</option>
                                                        <option value="20000" <?php echo $xciptv_ort_settings['player_exo_buffer'] == '20000' ? 'selected' : ''; ?>>20 Seconds</option>
                                                        <option value="30000" <?php echo $xciptv_ort_settings['player_exo_buffer'] == '30000' ? 'selected' : ''; ?>>30 Seconds</option>
                                                        <option value="40000" <?php echo $xciptv_ort_settings['player_exo_buffer'] == '40000' ? 'selected' : ''; ?>>40 Seconds</option>
                                                        <option value="50000" <?php echo $xciptv_ort_settings['player_exo_buffer'] == '50000' ? 'selected' : ''; ?>>50 Seconds</option>
                                                    </select>
                                                </div>

                                                <div class="form-group">
                                                    <label class="control-label" for="video_resize_exo">Set Zoom:</label>
                                                    <select class="form-control" id="select" name="video_resize_exo">
                                                        <option value="0" <?php echo $xciptv_ort_settings['video_resize_exo'] == '0' ? 'selected' : ''; ?>>Best Fit</option>
                                                        <option value="1" <?php echo $xciptv_ort_settings['video_resize_exo'] == '1' ? 'selected' : ''; ?>>Fixed Height</option>
                                                        <option value="2" <?php echo $xciptv_ort_settings['video_resize_exo'] == '2' ? 'selected' : ''; ?>>Fixed Width</option>
                                                        <option value="3" <?php echo $xciptv_ort_settings['video_resize_exo'] == '3' ? 'selected' : ''; ?>>Fill</option>
                                                        <option value="4" <?php echo $xciptv_ort_settings['video_resize_exo'] == '4' ? 'selected' : ''; ?>>Zoom</option>
                                                    </select>
                                                </div>

                                                <div class="form-group">
                                                    <label class="control-label" for="exo_hw">Enable Hardware Decoder:</label>
                                                    <select class="form-control" id="select" name="exo_hw">
                                                        <option value="yes" <?php echo $xciptv_ort_settings['exo_hw'] == 'yes' ? 'selected' : ''; ?>>Yes</option>
                                                        <option value="no" <?php echo $xciptv_ort_settings['exo_hw'] == 'no' ? 'selected' : ''; ?>>No</option>
                                                    </select>
                                                </div>

                                                <div class="form-group">
                                                    <label class="control-label" for="video_subtitles_exo">Enable Subtitles:</label>
                                                    <select class="form-control" id="select" name="video_subtitles_exo">
                                                        <option value="yes" <?php echo $xciptv_ort_settings['video_subtitles_exo'] == 'yes' ? 'selected' : ''; ?>>Yes</option>
                                                        <option value="no" <?php echo $xciptv_ort_settings['video_subtitles_exo'] == 'no' ? 'selected' : ''; ?>>No</option>
                                                        </select>
                                                </div>

                                                <div class="form-group">
                                                    <label class="control-label" for="last_volume_exo">Set Default Volume:</label>
                                                    <select class="form-control" id="select" name="last_volume_exo">
                                                        <option value="60" <?php echo $xciptv_ort_settings['last_volume_exo'] == '60' ? 'selected' : ''; ?>>60%</option>
                                                        <option value="70" <?php echo $xciptv_ort_settings['last_volume_exo'] == '70' ? 'selected' : ''; ?>>70%</option>
                                                        <option value="80" <?php echo $xciptv_ort_settings['last_volume_exo'] == '80' ? 'selected' : ''; ?>>80%</option>
                                                        <option value="90" <?php echo $xciptv_ort_settings['last_volume_exo'] == '90' ? 'selected' : ''; ?>>90%</option>
                                                        <option value="100" <?php echo $xciptv_ort_settings['last_volume_exo'] == '100' ? 'selected' : ''; ?>>100%</option>
                                                    </select>
                                                </div>

                                                <div class="form-group">
                                                    <button class="btn btn-primary" name="submit_exo" type="submit">Save</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>

                                    <div class="col-6 float-right">
                                        VLC-Player Settings
                                        <div class="card-body">
                                            <form method="POST">
                                                <div class="form-group">
                                                    <label class="control-label" for="player_vlc_buffer">Set Buffer Size:</label>
                                                    <select class="form-control" id="select" name="player_vlc_buffer">
                                                        <option value="300" <?php echo $xciptv_ort_settings['player_vlc_buffer'] == '300' ? 'selected' : ''; ?>>300 Miliseconds</option>
                                                        <option value="1000" <?php echo $xciptv_ort_settings['player_vlc_buffer'] == '1000' ? 'selected' : ''; ?>>1 Second</option>
                                                        <option value="2000" <?php echo $xciptv_ort_settings['player_vlc_buffer'] == '2000' ? 'selected' : ''; ?>>2 Second</option>
                                                        <option value="3000" <?php echo $xciptv_ort_settings['player_vlc_buffer'] == '3000' ? 'selected' : ''; ?>>3 Second</option>
                                                        <option value="5000" <?php echo $xciptv_ort_settings['player_vlc_buffer'] == '5000' ? 'selected' : ''; ?>>5 Second</option>
                                                    </select>
                                                </div>

                                                <div class="form-group">
                                                    <label class="control-label" for="video_resize_vlc">Set Zoom:</label>
                                                    <select class="form-control" id="select" name="video_resize_vlc">
                                                        <option value="0" <?php echo $xciptv_ort_settings['video_resize_vlc'] == '0' ? 'selected' : ''; ?>>Best Fit</option>
                                                        <option value="1" <?php echo $xciptv_ort_settings['video_resize_vlc'] == '1' ? 'selected' : ''; ?>>16:9</option>
                                                        <option value="2" <?php echo $xciptv_ort_settings['video_resize_vlc'] == '2' ? 'selected' : ''; ?>>4:3</option>
                                                        <option value="3" <?php echo $xciptv_ort_settings['video_resize_vlc'] == '3' ? 'selected' : ''; ?>>Original</option>
                                                        <option value="4" <?php echo $xciptv_ort_settings['video_resize_vlc'] == '4' ? 'selected' : ''; ?>>Fill</option>
                                                    </select>
                                                </div>

                                                <div class="form-group">
                                                    <label class="control-label" for="vlc_hw">Enable Hardware Decoder:</label>
                                                    <select class="form-control" id="select" name="vlc_hw">
                                                        <option value="yes" <?php echo $xciptv_ort_settings['vlc_hw'] == 'yes' ? 'selected' : ''; ?>>Yes</option>
                                                        <option value="no" <?php echo $xciptv_ort_settings['vlc_hw'] == 'no' ? 'selected' : ''; ?>>No</option>
                                                    </select>
                                                </div>

                                                <div class="form-group">
                                                    <label class="control-label" for="video_subtitles_vlc">Enable Subtitles:</label>
                                                    <select class="form-control" id="select" name="video_subtitles_vlc">
                                                        <option value="yes" <?php echo $xciptv_ort_settings['video_subtitles_vlc'] == 'yes' ? 'selected' : ''; ?>>Yes</option>
                                                        <option value="no" <?php echo $xciptv_ort_settings['video_subtitles_vlc'] == 'no' ? 'selected' : ''; ?>>No</option>
                                                    </select>
                                                </div>

                                                <div class="form-group">
                                                    <label class="control-label" for="last_volume_vlc">Set Default Volume:</label>
                                                    <select class="form-control" id="select" name="last_volume_vlc">
                                                        <option value="60" <?php echo $xciptv_ort_settings['last_volume_vlc'] == '60' ? 'selected' : ''; ?>>60%</option>
                                                        <option value="70" <?php echo $xciptv_ort_settings['last_volume_vlc'] == '70' ? 'selected' : ''; ?>>70%</option>
                                                        <option value="80" <?php echo $xciptv_ort_settings['last_volume_vlc'] == '80' ? 'selected' : ''; ?>>80%</option>
                                                        <option value="90" <?php echo $xciptv_ort_settings['last_volume_vlc'] == '90' ? 'selected' : ''; ?>>90%</option>
                                                        <option value="100" <?php echo $xciptv_ort_settings['last_volume_vlc'] == '100' ? 'selected' : ''; ?>>100%</option>
                                                    </select>
                                                </div>

                                                <div class="form-group">
                                                    <button class="btn btn-primary" name="submit_vlc" type="submit">Save</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Additional Settings Section -->
                    <div class="row">
                        <!-- Intro Video Settings -->
                        <div class="col-6">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="card-title">Intro Video</h4>
                                    <p class="card-title-desc">
                                        The selected video will affect all connected applications.<br>
                                        Not all Apps support Intro video (from remote).
                                    </p>

                                    <form method="POST" enctype="multipart/form-data">
                                        <div class="input-group">
                                            <div class="custom-file">
                                                <input class="form-control" name="intro" id="intro" type="file" accept="video/*">
                                                <button class="btn btn-warning" type="submit" name="submit_intro">
                                                    <i class="ri-upload-line"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </form>

                                    <br>

                                    <div class="row">
                                        <div class="col-sm-12">
                                            <video class="card-img-bottom" width="200px" controls>
                                                <source src="./api/intro.mp4" type="video/mp4">
                                            </video>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- TV Sports Guide Settings -->
                        <div class="col-6">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="card-title">TVSportsGuide</h4>
                                    <p class="card-title-desc">
                                        The selected design will affect all connected applications.<br>
                                        Not all Apps support <a href="https://www.tvsportguide.com/page/widget/">TVSportsGuide.</a>
                                    </p>

                                    <form method="POST">
                                        <div class="row">
                                            <div class="col-12">
                                                <div class="form-group">
                                                    <label for="widget_id"><a href="/assets/images/tvspg.png">Widget ID</a></label>
                                                    <input type="text" class="form-control float-right" id="widget_id" 
                                                           name="widget_id" placeholder="Widget ID" 
                                                           value="<?php echo $tvsg_settings['widget_id']; ?>">
                                                </div>
                                            </div>
                                        </div>

                                        <br>

                                        <div class="row">
                                            <div class="col-4">
                                                <div class="form-group">
                                                    <label for="border_color">Border Color</label>
                                                    <input type="color" class="form-control" id="border_color" 
                                                           name="border_color" value="<?php echo $tvsg_settings['border_color']; ?>">
                                                </div>
                                            </div>

                                            <div class="col-4">
                                                <div class="form-group">
                                                    <label for="background_color">Background Color</label>
                                                    <input type="color" class="form-control" id="background_color" 
                                                           name="background_color" value="<?php echo $tvsg_settings['background_color']; ?>">
                                                </div>
                                            </div>

                                            <div class="col-4">
                                                <div class="form-group">
                                                    <label for="text_color">Text Color</label>
                                                    <input type="color" class="form-control" id="text_color" 
                                                           name="text_color" value="<?php echo $tvsg_settings['text_color']; ?>">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <button class="btn btn-primary" name="submit_tvsg" type="submit">Save</button>
                                        </div>

                                        <hr>
                                        <a href="https://www.tvsportguide.com/widget/<?php echo $tvsg_settings['widget_id']; ?>/?heading=Events&border_color=custom&autoscroll=1&custom_colors=<?php echo substr($tvsg_settings['border_color'], 1); ?>,<?php echo substr($tvsg_settings['background_color'], 1); ?>,<?php echo substr($tvsg_settings['text_color'], 1); ?>">Preview Widget</a>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php include 'assets/includes/footer.php'; ?>
    </div>

    <?php include 'assets/includes/right-sidebar.php'; ?>
    <?php include 'assets/includes/vendor-scripts.php'; ?>
    
    <script src="./assets/js/app.js"></script>
</body>
</html>